#Podemos digitar nossa matriz
mat1 <-matrix(data=1:12,nrow=3,ncol=4)

#Digitando a matriz de var-cov da aula
s<-matrix(c(23,-12,-12,16), nrow=2, ncol=2)
##Vizualizando
#Digitando a matriz de correlação
r<-matrix(c(1,-0,626,-0,626,1), nrow=2, ncol=2)
##Vizualizando a matriz r
r

#######################################################
#Trabalhando com um banco de dados
#Criando o banco de dados com as variáveis quantiativas
caatinga.q <-caatinga[1:93, 4:22]
#Calculando a matriz de var-cov(X)
cov.c<-cov(caatinga.q)
#Checando o tipo do objeto cov.c
class(cov.c)
##Vizualiando apenas alguns elementos da matriz var-cov(X)
cov.c [1:2 ,1:3]
##Calculando a variância total:
sum( diag (cov.c))
##Calculando a variância generalizada:
det(cov.c)
#---------------------------------------------------
#Calculando a matriz de correlação(X)
cor.c<-cor(caatinga.q)
#Calculando a correlação para apenas as variáveis prvegetaln e pranimal
cor2 <-cor(caatinga.q$prvegetal,caatinga.q$pranimal,caatinga.q$agropecuaria)
#Vizualizando apenas algumas células da matriz cor.c
cor.c [2:3 ,1:4]
##Calculando a variância total 
var.total<-sum( diag (cor.c))
var.total
#----------------------------------------------------
#Calculando os autovalores e autovetores para cor.c
ev <- eigen(cor.c)
#Vizualizando os dados armazenados no objetivo ev
ev
# Extraindo os autovalores
c.valores <- ev$values
#Extraindo os autovetores
c.vetores <- ev$vectors
##Calculando o percentual explicado por cada componente (Yi=ei1x1+ei2x2+...+eipxp)
per.var <- c((c.valores/var.total)*100)
per.var
#########################################################
#Análise de Componentes Principais.
#Primeiramente, devemos instalar os pacotes que iremos utilizar
install.packages(c("FactoMineR", #para a análise
                   "factoextra" #para plotar os componentes principais
                   ))
#Após instalar, devemos colocar ambos na memória do R
#Atenção, devemos fazer esse procedimento toda vez que abrirmos o R (RStudio)
library(FactoMineR, factoextra)
res.pca <- PCA(caatinga.q, graph = FALSE)
res.pca <- PCA(caatinga.q, graph = T)
print(res.pca)
#Veja os componentes incluídos no objeto res.pca
##Os valores para cada um dos componentes estão armazenados em
## ind$coord.
eig.val <- get_eigenvalue(res.pca)
##Determinando o número de componentes a serem mantidos
##Pelo critério de Kaiser, considere os autovalores >=1
##Podemos limitar o nº também considerando o critério de 
###explicar 70% da variância total dos dados
eig.val
##Se considerarmos autovalor>1, devemos manter 6 componentes
##Se considermos explicar 70% da variância, devemos manter 5 componentes
##Não há um critério objetivo, na prática depende do campo de pesquisa
#Determinando o número de componentes principais a serem mantidos
##Podemos usar o scree-plot
##Fazendo o scree plot, observe o ponto em que a variância explicada
###tente a estabilizar.
fviz_eig(res.pca)
fviz_eig(res.pca, addlabels = TRUE, xlab="Dimensões", ylab = "Percentual da variância explicada", ylim = c(0, 35))
#Esse ponto é dado no 5 componentes

#--------------------------------------------------------
#Círculo de correlação
fviz_pca_var(res.pca, #nome do objeto que foi salvo os resultados
             col.var = "black" ,
             repel = TRUE, # Evita que o texto se sobreponha
            title = "#Círulo de correlação, variáveis x PC" #título
              )
#A correlação entre uma variável eo o componente principal é usada
##como coordenada para a variável no PC
##Ele mostra a relação entre todas as variáveis
##Variáveis correlacionadas positivamente são agrupadas;
##Variáveis negativamente correlacionadas são posicionadas em lados
## opostos em relação à origem (quadrantes opostos)
##A distância entre as variáveis e a origem é uma medida de qualidade
## no mapa de fator: variáveis mais distantes da origem estão melhor
## representadas

#---------------------------------------------------------
#Qualidade da representação
#É mensurado pelo cos2
install.packages("corrplot")
library("corrplot")
corrplot(res.pca$var$cos2, is.corr=FALSE)
fviz_cos2(res.pca, choice = "var", axes = 1:2,
          title =("Gráfico de barras para o cos2"))
#Um cos2 elevado indica uma boa representação da variável sobre
## o PC. Nesse caso a variável é posicionada próxima à circunferência
## do cículo de correlação.
#Um cos2 baixo indica que a variável não é perfeitamente representada pelos
## componentes principais. Nesse caso, a variáve está próxima do 
## centro do círculo
#Podemos representar as variáveis de forma colorida e em gradiente
## no círculode correlação usando o argumento col.var = “cos2”. 
# Para gradient.cols = c(“white”, “blue”, “red”) temos:
## variáveis com baixo cos2 serão coloridas de branco;
## variables com cos2 próximo à médidas serão azuis;
## variáveis com elevado cos2 serão vermelhas
fviz_pca_var(res.pca, col.var = "cos2",
             gradient.cols = c("#00AFBB", "#E7B800", "#FC4E07"),
             repel = TRUE # Avoid text overlapping
)
#-----------------------------------------------------------
#Contribuição das variáveis para os PC
#Variáveis que estão correlacionadas com o PC1 (Dim1) e PC2(Dim2)
## são as mais importantes para explicar a variabilidade dos dados
#Variáveis que não são correlacionadas com nenhum PC ou são
## correlacionadas com as últimas dimensões são menos importantes
## e podem ser removidas para simplificar a análise
head(res.pca$var$contrib, 4)
corrplot(res.pca$var$contrib, is.corr=FALSE)
#Se os dados contém muitas variáveis, podemos exibir apenas as 
## mais importantes em termos de contribuição para os PCs
# Contribuição das variáveis para o PC1
fviz_contrib(res.pca, choice = "var", axes = 1, top = 10,
             title ="Contribuição das variáveis para a Dim 1"
             )
# Contribuição das variáveis para o PC2
fviz_contrib(res.pca, choice = "var", axes = 2, top = 10,
             title ="Contribuição das variáveis para a Dim 2"
)
#Contribuição das variáveis para o PC1 e PC2
fviz_contrib(res.pca, choice = "var", axes = 1:2, top = 10)
#A linha pontilhada vermelha no gráfico indica o valor médio
## esperado. Se a contribuição das variáveis é uniforme, o valor
## esperado será 1/n (número de variáveis). Como no exemplo são 19
## variáveis = 1/19 = 5,26%. Variáveis com contribuição acima desse
## valor podem ser consideradas como importantes para o componente

# Podemos usar a função dimdesc() [in FactoMineR], para identificar
## as variáveis associadas com maior significância com o componente
res.desc <- dimdesc(res.pca, axes = c(1,2), proba = 0.05)
print(res.desc)
#----------------------------------------------------------
#Para exportar os resultados, usamos
write.infile(res.pca, "pca.csv", sep = ";")
#Os valores dos autovetores estarão no final do arquivo identificados
## como "V" para os componentes extráidos
#Salvando o valor dos componentes
cp <- res.pca$ind$coord
#Exportando para um arquivo .csv de nome cp
write.infile(cp, "cp.csvv", sep = ";")
